/*
 * Decompiled with CFR 0.152.
 */
package de.unhappycodings.quarry.common.container;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.unhappycodings.quarry.Quarry;
import de.unhappycodings.quarry.client.config.ClientConfig;
import de.unhappycodings.quarry.client.gui.GuiUtil;
import de.unhappycodings.quarry.client.gui.widgets.ModButton;
import de.unhappycodings.quarry.common.container.AreaCardContainer;
import de.unhappycodings.quarry.common.container.base.BaseScreen;
import de.unhappycodings.quarry.common.container.base.ModEditBox;
import de.unhappycodings.quarry.common.item.AreaCardItem;
import de.unhappycodings.quarry.common.network.PacketHandler;
import de.unhappycodings.quarry.common.network.toserver.AreaCardItemPacket;
import de.unhappycodings.quarry.common.util.CalcUtil;
import de.unhappycodings.quarry.common.util.NbtUtil;
import de.unhappycodings.quarry.common.util.RenderUtil;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class AreaCardScreen
extends BaseScreen<AreaCardContainer> {
    public static final ResourceLocation GHOST_OVERLAY = new ResourceLocation("quarry", "textures/gui/slot/filter_overlay.png");
    public static final ResourceLocation GHOST_OVERLAY_DARK = new ResourceLocation("quarry", "textures/gui/slot/filter_overlay_dark.png");
    public static ModButton darkmodeMouseButton;
    public ModEditBox pos1x;
    public ModEditBox pos1y;
    public ModEditBox pos1z;
    public ModEditBox pos2x;
    public ModEditBox pos2y;
    public ModEditBox pos2z;
    public ModEditBox top;
    public ModEditBox down;
    public ModEditBox[] positionInputs;
    public ModEditBox[] heightInputs;
    AreaCardContainer container;
    int selectionMode = 0;
    boolean darkmodeButtonIsHovered;
    boolean init1 = false;
    boolean init2 = false;
    boolean init3 = false;
    boolean init4 = false;
    int blockRadius = 0;
    int chunkRadius = 0;
    long blockCount = 1L;
    byte[][] posList = new byte[][]{{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8}, {8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8}, {8, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 8}, {8, 7, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 7, 8}, {8, 7, 6, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 6, 7, 8}, {8, 7, 6, 5, 4, 3, 3, 3, 3, 3, 3, 3, 4, 5, 6, 7, 8}, {8, 7, 6, 5, 4, 3, 2, 2, 2, 2, 2, 3, 4, 5, 6, 7, 8}, {8, 7, 6, 5, 4, 3, 2, 1, 1, 1, 2, 3, 4, 5, 6, 7, 8}, {8, 7, 6, 5, 4, 3, 2, 1, 9, 1, 2, 3, 4, 5, 6, 7, 8}, {8, 7, 6, 5, 4, 3, 2, 1, 1, 1, 2, 3, 4, 5, 6, 7, 8}, {8, 7, 6, 5, 4, 3, 2, 2, 2, 2, 2, 3, 4, 5, 6, 7, 8}, {8, 7, 6, 5, 4, 3, 3, 3, 3, 3, 3, 3, 4, 5, 6, 7, 8}, {8, 7, 6, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 6, 7, 8}, {8, 7, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 7, 8}, {8, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 8}, {8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8}, {8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8}};

    public AreaCardScreen(AreaCardContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.container = screenContainer;
    }

    @Override
    public void m_6305_(@NotNull PoseStack matrixStack, int x, int y, float partialTicks) {
        super.m_6305_(matrixStack, x, y, partialTicks);
        ItemStack stack = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        for (ModEditBox editBox : this.positionInputs) {
            if (editBox == null || stack.m_41784_().m_128451_("Selection") != 0) continue;
            editBox.m_6305_(matrixStack, x, y, partialTicks);
        }
        for (ModEditBox editBox : this.heightInputs) {
            if (editBox == null || stack.m_41784_().m_128451_("Selection") != 2) continue;
            editBox.m_6305_(matrixStack, x, y, partialTicks);
        }
    }

    @Override
    protected void m_7286_(@NotNull PoseStack matrixStack, float partialTicks, int x, int y) {
        super.m_7286_(matrixStack, partialTicks, x, y);
        ItemStack stack = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        if (stack.m_41784_().m_128451_("Selection") == 1) {
            this.m_93228_(matrixStack, this.f_97735_ + 60, this.f_97736_ + 61, 0, 150, 78, 14);
        }
        if (stack.m_41784_().m_128451_("Selection") == 2) {
            this.m_93228_(matrixStack, this.f_97735_ + 17, this.f_97736_ + 52, 0, 150, 78, 14);
            this.m_93228_(matrixStack, this.f_97735_ + 115, this.f_97736_ + 25, 198, 0, 56, 56);
            this.m_93228_(matrixStack, this.f_97735_ + 15, this.f_97736_ + 70, 0, 165, 81, 15);
            for (int i = 0; i < 17; ++i) {
                for (int e = 0; e < 17; ++e) {
                    if (this.posList[i][e] > this.chunkRadius) continue;
                    this.m_93228_(matrixStack, (int)((double)(this.f_97735_ + 118) + Math.ceil(e * 3)), (int)((double)(this.f_97736_ + 28) + Math.ceil(i * 3)), 198, 57, 2, 2);
                }
            }
        }
    }

    protected void m_7027_(@NotNull PoseStack pPoseStack, int pMouseX, int pMouseY) {
        ItemStack stack = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        if (stack.m_41784_().m_128451_("Selection") == 0) {
            BlockPos pos;
            this.drawText(Component.m_237115_((String)"item.quarry.areacard.text.pos_1").getString(), pPoseStack, 34, 20);
            this.drawText(Component.m_237115_((String)"item.quarry.areacard.text.pos_2").getString(), pPoseStack, 118, 20);
            this.drawText(Component.m_237113_((String)"X").getString(), pPoseStack, 9, 35);
            this.drawText(Component.m_237113_((String)"Y").getString(), pPoseStack, 9, 52);
            this.drawText(Component.m_237113_((String)"Z").getString(), pPoseStack, 9, 69);
            this.drawText(Component.m_237113_((String)"X").getString(), pPoseStack, 184, 35);
            this.drawText(Component.m_237113_((String)"Y").getString(), pPoseStack, 184, 52);
            this.drawText(Component.m_237113_((String)"Z").getString(), pPoseStack, 184, 69);
            if (!this.init1) {
                pos = BlockPos.f_121853_;
                if (stack.m_41784_().m_128441_("pos1")) {
                    pos = NbtUtil.getPos(stack.m_41784_().m_128469_("pos1"));
                }
                this.pos1x.setValue(String.valueOf(pos.m_123341_()));
                this.pos1y.setValue(String.valueOf(pos.m_123342_()));
                this.pos1z.setValue(String.valueOf(pos.m_123343_()));
                this.init1 = true;
            }
            if (!this.init2) {
                pos = BlockPos.f_121853_;
                if (stack.m_41784_().m_128441_("pos2")) {
                    pos = NbtUtil.getPos(stack.m_41784_().m_128469_("pos2"));
                }
                this.pos2x.setValue(String.valueOf(pos.m_123341_()));
                this.pos2y.setValue(String.valueOf(pos.m_123342_()));
                this.pos2z.setValue(String.valueOf(pos.m_123343_()));
                this.init2 = true;
            }
        }
        if (stack.m_41784_().m_128451_("Selection") == 1) {
            this.drawText(Component.m_237115_((String)"item.quarry.areacard.text.around").getString(), pPoseStack, 61, 32);
            this.drawCenteredText(Component.m_237113_((String)String.valueOf(this.blockRadius)).getString(), pPoseStack, 101, 46);
            this.drawCenteredText(Component.m_237113_((String)"#").m_130946_(String.valueOf(this.blockCount)).getString(), pPoseStack, 100, 65);
            if (!this.init4) {
                int sizeZ;
                int sizeX;
                BlockPos pos1 = BlockPos.f_121853_;
                if (stack.m_41784_().m_128441_("pos1")) {
                    pos1 = NbtUtil.getPos(stack.m_41784_().m_128469_("pos1"));
                }
                BlockPos pos2 = BlockPos.f_121853_;
                if (stack.m_41784_().m_128441_("pos2")) {
                    pos2 = NbtUtil.getPos(stack.m_41784_().m_128469_("pos2"));
                }
                int blocksWidth = (sizeX = Math.abs(pos1.m_123341_() - pos2.m_123341_()) + 1) == (sizeZ = Math.abs(pos1.m_123343_() - pos2.m_123343_()) + 1) ? sizeX : 0;
                this.blockRadius = (blocksWidth - 1) / 2;
                this.refreshCount();
                this.init4 = true;
            }
        }
        if (stack.m_41784_().m_128451_("Selection") == 2) {
            int multiplicator = 384;
            boolean valid = false;
            if ((this.top.getValue().matches("^-?(\\d+$)") || this.top.getValue().matches("[0-9-]]")) && (this.down.getValue().matches("^-?(\\d+$)") || this.down.getValue().matches("[0-9-]]"))) {
                if (Integer.parseInt(this.top.getValue()) > Integer.parseInt(this.down.getValue())) {
                    valid = true;
                }
                multiplicator = Math.abs(Math.abs(Integer.parseInt(this.top.getValue())) + Math.abs(Integer.parseInt(this.down.getValue())));
            }
            int count = (this.chunkRadius * 2 + 1) * (this.chunkRadius * 2 + 1) * (256 * multiplicator);
            this.drawText(Component.m_237115_((String)"item.quarry.areacard.text.framing").getString(), pPoseStack, 18, 23);
            this.drawCenteredText(Component.m_237113_((String)String.valueOf(this.chunkRadius)).getString(), pPoseStack, 56, 37);
            this.drawCenteredTextColored(Component.m_237113_((String)(valid ? "#" : "")).m_130946_(String.valueOf(valid ? Integer.valueOf(count) : Component.m_237115_((String)"item.quarry.areacard.text.illegal").getString())).getString(), pPoseStack, 55, 56, valid ? 0x141414 : 0xFE5E5E);
            if (!this.init3) {
                int sizeZ;
                int sizeX;
                BlockPos pos1 = BlockPos.f_121853_;
                if (stack.m_41784_().m_128441_("pos1")) {
                    pos1 = NbtUtil.getPos(stack.m_41784_().m_128469_("pos1"));
                }
                BlockPos pos2 = BlockPos.f_121853_;
                if (stack.m_41784_().m_128441_("pos2")) {
                    pos2 = NbtUtil.getPos(stack.m_41784_().m_128469_("pos2"));
                }
                int chunkWidth = (sizeX = Math.abs(pos1.m_123341_() - pos2.m_123341_()) + 1) / 16 == (sizeZ = Math.abs(pos1.m_123343_() - pos2.m_123343_()) + 1) / 16 ? sizeX / 16 : 0;
                this.chunkRadius = (chunkWidth - 1) / 2;
                this.top.setValue("" + pos1.m_123342_());
                this.down.setValue("" + pos2.m_123342_());
                this.init3 = true;
            }
        }
        if (this.darkmodeButtonIsHovered) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            if (this.getDarkModeConfigValue()) {
                list.add(Component.m_237115_((String)"gui.quarry.darkmode.dark"));
                list.add(Component.m_237115_((String)"gui.quarry.darkmode.dark.switch").m_130940_(ChatFormatting.YELLOW));
            } else {
                list.add(Component.m_237115_((String)"gui.quarry.darkmode.white"));
                list.add(Component.m_237115_((String)"gui.quarry.darkmode.white.switch").m_130940_(ChatFormatting.YELLOW));
            }
            this.m_96597_(pPoseStack, list, pMouseX - this.f_97735_, pMouseY - this.f_97736_);
        }
        this.drawText(Component.m_237115_((String)"item.quarry.areacard.text.pos").getString(), pPoseStack, 33, 6);
        this.drawText(Component.m_237115_((String)"item.quarry.areacard.text.radius").getString(), pPoseStack, 84, 6);
        this.drawText(Component.m_237115_((String)"item.quarry.areacard.text.chunk").getString(), pPoseStack, 140, 6);
        this.drawText(Component.m_237115_((String)"item.quarry.areacard.text.save").getString(), pPoseStack, 88, 91);
        this.drawText(Component.m_237115_((String)"item.quarry.areacard.text.filter").getString(), pPoseStack, 87, 108);
        CompoundTag tag = stack.m_41784_().m_128469_("Filters");
        this.renderGhostOverlay(pPoseStack, new ItemStack((ItemLike)Blocks.f_50652_), 40, 120, tag.m_128471_("0"));
        this.renderGhostOverlay(pPoseStack, new ItemStack((ItemLike)Blocks.f_50069_), 58, 120, tag.m_128471_("1"));
        this.renderGhostOverlay(pPoseStack, new ItemStack((ItemLike)Blocks.f_49994_), 76, 120, tag.m_128471_("2"));
        this.renderGhostOverlay(pPoseStack, new ItemStack((ItemLike)Blocks.f_50493_), 94, 120, tag.m_128471_("3"));
        this.renderGhostOverlay(pPoseStack, new ItemStack((ItemLike)Blocks.f_49992_), 112, 120, tag.m_128471_("4"));
        this.renderGhostOverlay(pPoseStack, new ItemStack((ItemLike)Blocks.f_49993_), 130, 120, tag.m_128471_("5"));
        this.renderGhostOverlay(pPoseStack, new ItemStack((ItemLike)Blocks.f_50134_), 148, 120, tag.m_128471_("6"));
    }

    public void renderGhostOverlay(PoseStack stack, ItemStack item, int x, int y, boolean normal) {
        stack.m_85836_();
        RenderUtil.renderGuiItem(item, x, y);
        RenderSystem.m_157456_((int)0, (ResourceLocation)(normal ? Quarry.BLANK : ((Boolean)ClientConfig.enableQuarryDarkmode.get() != false ? GHOST_OVERLAY_DARK : GHOST_OVERLAY)));
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.65f);
        RenderSystem.m_69478_();
        RenderSystem.m_69465_();
        GuiComponent.m_93133_((PoseStack)stack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        RenderSystem.m_69461_();
        RenderSystem.m_69482_();
        GuiUtil.reset();
        stack.m_85849_();
    }

    public void m_7379_() {
        super.m_7379_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.pos1x = new ModEditBox(this.f_96547_, this.f_97735_ + 20, this.f_97736_ + 34, 71, 10, (Component)Component.m_237119_());
        this.pos1y = new ModEditBox(this.f_96547_, this.f_97735_ + 20, this.f_97736_ + 51, 71, 10, (Component)Component.m_237119_());
        this.pos1z = new ModEditBox(this.f_96547_, this.f_97735_ + 20, this.f_97736_ + 68, 71, 10, (Component)Component.m_237119_());
        this.pos2x = new ModEditBox(this.f_96547_, this.f_97735_ + 107, this.f_97736_ + 34, 71, 10, (Component)Component.m_237119_());
        this.pos2y = new ModEditBox(this.f_96547_, this.f_97735_ + 107, this.f_97736_ + 51, 71, 10, (Component)Component.m_237119_());
        this.pos2z = new ModEditBox(this.f_96547_, this.f_97735_ + 107, this.f_97736_ + 68, 71, 10, (Component)Component.m_237119_());
        this.positionInputs = new ModEditBox[]{this.pos1x, this.pos1y, this.pos1z, this.pos2x, this.pos2y, this.pos2z};
        this.top = new ModEditBox(this.f_96547_, this.f_97735_ + 27, this.f_97736_ + 73, 25, 10, (Component)Component.m_237119_());
        this.down = new ModEditBox(this.f_96547_, this.f_97735_ + 69, this.f_97736_ + 73, 25, 10, (Component)Component.m_237119_());
        this.heightInputs = new ModEditBox[]{this.top, this.down};
        this.subInit();
        this.addElements();
    }

    protected boolean m_6774_(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        if (darkmodeMouseButton != null && darkmodeMouseButton.m_5953_(pMouseX, pMouseY)) {
            this.darkmodeButtonIsHovered = true;
        } else if (this.darkmodeButtonIsHovered) {
            this.darkmodeButtonIsHovered = false;
        }
        return super.m_6774_(pX, pY, pWidth, pHeight, pMouseX, pMouseY);
    }

    protected void subInit() {
        this.f_96541_.f_91068_.m_90926_(true);
        for (ModEditBox editBox : this.positionInputs) {
            editBox.setBordered(false);
            editBox.setEditable(true);
            editBox.setMaxLength(10);
            editBox.setFilter(this::isInputValid);
            this.m_7787_(editBox);
        }
        for (ModEditBox editBox : this.heightInputs) {
            editBox.setBordered(false);
            editBox.setEditable(true);
            editBox.setMaxLength(4);
            editBox.setFilter(this::isInputValid);
            this.m_7787_(editBox);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        for (ModEditBox editBox : this.positionInputs) {
            editBox.setFocus(false);
            if (!editBox.m_198029_()) continue;
            this.m_94718_(editBox);
        }
        for (ModEditBox editBox : this.heightInputs) {
            editBox.setFocus(false);
            if (!editBox.m_198029_()) continue;
            this.m_94718_(editBox);
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    protected void addElements() {
        boolean darkmode = this.getDarkModeConfigValue();
        ItemStack stack = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        if (stack.m_41784_().m_128451_("Selection") == 0) {
            this.m_169394_((Widget)new ModButton(18, 31, 75, 14, darkmode ? Quarry.FIELD_DARK : Quarry.FIELD, null, null, null, this, 75, 28, false));
            this.m_169394_((Widget)new ModButton(18, 48, 75, 14, darkmode ? Quarry.FIELD_DARK : Quarry.FIELD, null, null, null, this, 75, 28, false));
            this.m_169394_((Widget)new ModButton(18, 65, 75, 14, darkmode ? Quarry.FIELD_DARK : Quarry.FIELD, null, null, null, this, 75, 28, false));
            this.m_169394_((Widget)new ModButton(105, 31, 75, 14, darkmode ? Quarry.FIELD_DARK : Quarry.FIELD, null, null, null, this, 75, 28, false));
            this.m_169394_((Widget)new ModButton(105, 48, 75, 14, darkmode ? Quarry.FIELD_DARK : Quarry.FIELD, null, null, null, this, 75, 28, false));
            this.m_169394_((Widget)new ModButton(105, 65, 75, 14, darkmode ? Quarry.FIELD_DARK : Quarry.FIELD, null, null, null, this, 75, 28, false));
        }
        if (stack.m_41784_().m_128451_("Selection") == 1) {
            this.m_142416_((GuiEventListener)new ModButton(75, 43, 10, 14, darkmode ? Quarry.COUNTER_DOWN_DARK : Quarry.COUNTER_DOWN, () -> this.cycleBlockRadius(-1), null, null, this, 10, 28, true));
            this.m_142416_((GuiEventListener)new ModButton(115, 43, 10, 14, darkmode ? Quarry.COUNTER_UP_DARK : Quarry.COUNTER_UP, () -> this.cycleBlockRadius(1), null, null, this, 10, 28, true));
        }
        if (stack.m_41784_().m_128451_("Selection") == 2) {
            this.m_142416_((GuiEventListener)new ModButton(37, 34, 10, 14, darkmode ? Quarry.COUNTER_DOWN_DARK : Quarry.COUNTER_DOWN, () -> this.cycleChunkRadius(-1), null, null, this, 10, 28, true));
            this.m_142416_((GuiEventListener)new ModButton(63, 34, 10, 14, darkmode ? Quarry.COUNTER_UP_DARK : Quarry.COUNTER_UP, () -> this.cycleChunkRadius(1), null, null, this, 10, 28, true));
        }
        darkmodeMouseButton = new ModButton(182, 5, 9, 9, darkmode ? Quarry.DARK_MODE : Quarry.WHITE_MODE, () -> {
            this.refreshWidgets();
            this.setDarkModeConfigValue(!this.getDarkModeConfigValue());
        }, null, null, this, 9, 18, true);
        this.m_142416_((GuiEventListener)darkmodeMouseButton);
        this.m_142416_((GuiEventListener)new ModButton(40, 120, 16, 16, Quarry.BLANK, () -> this.changeFilter(0), null, null, this, 16, 16, true));
        this.m_142416_((GuiEventListener)new ModButton(58, 120, 16, 16, Quarry.BLANK, () -> this.changeFilter(1), null, null, this, 16, 16, true));
        this.m_142416_((GuiEventListener)new ModButton(76, 120, 16, 16, Quarry.BLANK, () -> this.changeFilter(2), null, null, this, 16, 16, true));
        this.m_142416_((GuiEventListener)new ModButton(94, 120, 16, 16, Quarry.BLANK, () -> this.changeFilter(3), null, null, this, 16, 16, true));
        this.m_142416_((GuiEventListener)new ModButton(112, 120, 16, 16, Quarry.BLANK, () -> this.changeFilter(4), null, null, this, 16, 16, true));
        this.m_142416_((GuiEventListener)new ModButton(130, 120, 16, 16, Quarry.BLANK, () -> this.changeFilter(5), null, null, this, 16, 16, true));
        this.m_142416_((GuiEventListener)new ModButton(148, 120, 16, 16, Quarry.BLANK, () -> this.changeFilter(6), null, null, this, 16, 16, true));
        this.m_142416_((GuiEventListener)new ModButton(23, 6, 7, 7, stack.m_41784_().m_128451_("Selection") == 0 ? Quarry.SELECTOR : Quarry.SELECTOR_OFF, () -> stack.m_41784_().m_128405_("Selection", 0), null, null, this, 7, 14, true));
        this.m_142416_((GuiEventListener)new ModButton(74, 6, 7, 7, stack.m_41784_().m_128451_("Selection") == 1 ? Quarry.SELECTOR : Quarry.SELECTOR_OFF, () -> stack.m_41784_().m_128405_("Selection", 1), null, null, this, 7, 14, true));
        this.m_142416_((GuiEventListener)new ModButton(130, 6, 7, 7, stack.m_41784_().m_128451_("Selection") == 2 ? Quarry.SELECTOR : Quarry.SELECTOR_OFF, () -> stack.m_41784_().m_128405_("Selection", 2), null, null, this, 7, 14, true));
        this.m_142416_((GuiEventListener)new ModButton(70, 88, 59, 14, darkmode ? Quarry.SAVE_DARK : Quarry.SAVE, () -> this.savePositions(), null, null, this, 59, 28, true));
    }

    public void cycleChunkRadius(int add) {
        if (add > 0) {
            if (this.chunkRadius == 8) {
                this.chunkRadius = 0;
                return;
            }
            this.chunkRadius += add;
        } else {
            if (this.chunkRadius == 0) {
                this.chunkRadius = 8;
                return;
            }
            this.chunkRadius += add;
        }
    }

    public void cycleBlockRadius(int add) {
        if (add > 0) {
            if (this.blockRadius == 1024) {
                this.blockRadius = 0;
                this.refreshCount();
                return;
            }
            if (this.blockRadius + add <= 1024) {
                this.blockRadius += add;
            }
        } else {
            if (this.blockRadius == 0) {
                this.blockRadius = 1024;
                this.refreshCount();
                return;
            }
            if (this.blockRadius + add >= 0) {
                this.blockRadius += add;
            }
        }
        this.refreshCount();
    }

    public void refreshCount() {
        BlockPos pos1 = this.getOffsetPos(this.blockRadius);
        BlockPos pos2 = this.getOffsetPos(-this.blockRadius);
        this.blockCount = CalcUtil.getBlockCount(pos1, pos2);
    }

    public BlockPos getOffsetPos(int modifier) {
        return new BlockPos((Vec3i)Minecraft.m_91087_().f_91074_.m_20183_().m_7918_(modifier, modifier, modifier));
    }

    public void m_6574_(@NotNull Minecraft pMinecraft, int pWidth, int pHeight) {
        ArrayList<String> posValues = new ArrayList<String>();
        ArrayList<String> heightValues = new ArrayList<String>();
        for (ModEditBox editBox : this.positionInputs) {
            posValues.add(editBox.getValue());
        }
        for (ModEditBox editBox : this.heightInputs) {
            heightValues.add(editBox.getValue());
        }
        this.m_6575_(pMinecraft, pWidth, pHeight);
        int i = 0;
        for (ModEditBox editBox : this.positionInputs) {
            editBox.setValue((String)posValues.get(i));
            ++i;
        }
        i = 0;
        for (ModEditBox editBox : this.heightInputs) {
            editBox.setValue((String)heightValues.get(i));
            ++i;
        }
    }

    public void savePositions() {
        ItemStack stack = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        String[] posString = new String[]{"x", "y", "z"};
        stack.m_41784_().m_128405_("lastBlock", 0);
        if (stack.m_41784_().m_128451_("Selection") == 0) {
            for (int e = 1; e <= 2; ++e) {
                ModEditBox[] modEditBoxArray;
                for (int i = 1; i < 3; ++i) {
                    CompoundTag tag = stack.m_41784_().m_128469_("pos" + e);
                    if (tag.m_128441_("x") || tag.m_128441_("y") || tag.m_128441_("z")) continue;
                    tag.m_128405_("x", 0);
                    tag.m_128405_("y", 0);
                    tag.m_128405_("z", 0);
                    stack.m_41784_().m_128365_("pos" + e, (Tag)tag);
                }
                if (!stack.m_41784_().m_128441_("pos" + e)) {
                    return;
                }
                BlockPos pos = NbtUtil.getPos(stack.m_41784_().m_128469_("pos" + e));
                if (e == 2) {
                    ModEditBox[] modEditBoxArray2 = new ModEditBox[3];
                    modEditBoxArray2[0] = this.pos2x;
                    modEditBoxArray2[1] = this.pos2y;
                    modEditBoxArray = modEditBoxArray2;
                    modEditBoxArray2[2] = this.pos2z;
                } else {
                    ModEditBox[] modEditBoxArray3 = new ModEditBox[3];
                    modEditBoxArray3[0] = this.pos1x;
                    modEditBoxArray3[1] = this.pos1y;
                    modEditBoxArray = modEditBoxArray3;
                    modEditBoxArray3[2] = this.pos1z;
                }
                ModEditBox[] posList = modEditBoxArray;
                for (int i = 0; i < posList.length; ++i) {
                    if (posList[i].getValue().isEmpty() || Objects.equals(posList[i].getValue(), String.valueOf(pos.m_123341_())) || !posList[i].getValue().matches("^-?(\\d+$)")) continue;
                    CompoundTag tag = stack.m_41784_().m_128469_("pos" + e);
                    int current = Integer.parseInt(posList[i].getValue());
                    if (posString[i].equals("y")) {
                        if (current > 320) {
                            current = 320;
                        }
                        if (current < -64) {
                            current = -64;
                        }
                    }
                    if (posString[i].equals("x") || posString[i].equals("z")) {
                        if (current > 30000000) {
                            current = 30000000;
                        }
                        if (current < -30000000) {
                            current = -30000000;
                        }
                    }
                    tag.m_128405_(posString[i], current);
                    stack.m_41784_().m_128365_("pos" + e, (Tag)tag);
                    PacketHandler.sendToServer(new AreaCardItemPacket(Minecraft.m_91087_().f_91074_.m_20148_(), stack));
                }
            }
        }
        if (stack.m_41784_().m_128451_("Selection") == 1) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("x", this.getOffsetPos(this.blockRadius).m_123341_());
            tag.m_128405_("y", this.getOffsetPos(this.blockRadius).m_123342_());
            tag.m_128405_("z", this.getOffsetPos(this.blockRadius).m_123343_());
            stack.m_41784_().m_128365_("pos1", (Tag)tag);
            tag = new CompoundTag();
            tag.m_128405_("x", this.getOffsetPos(-this.blockRadius).m_123341_());
            tag.m_128405_("y", this.getOffsetPos(-this.blockRadius).m_123342_());
            tag.m_128405_("z", this.getOffsetPos(-this.blockRadius).m_123343_());
            stack.m_41784_().m_128365_("pos2", (Tag)tag);
            PacketHandler.sendToServer(new AreaCardItemPacket(Minecraft.m_91087_().f_91074_.m_20148_(), stack));
        }
        if (stack.m_41784_().m_128451_("Selection") == 2) {
            CompoundTag tag = new CompoundTag();
            int offset1 = 7 + this.chunkRadius * 16;
            int offset2 = -8 - this.chunkRadius * 16;
            BlockPos chunkMiddle = Minecraft.m_91087_().f_91074_.m_146902_().m_151394_(0);
            BlockPos pos1 = chunkMiddle.m_7918_(offset1, 0, offset1);
            BlockPos pos2 = chunkMiddle.m_7918_(offset2, 0, offset2);
            Minecraft.m_91087_().f_91073_.m_7731_(pos1, Blocks.f_50108_.m_49966_(), 3);
            Minecraft.m_91087_().f_91073_.m_7731_(pos2, Blocks.f_50108_.m_49966_(), 3);
            tag.m_128405_("x", pos1.m_123341_());
            tag.m_128405_("y", Math.min(Integer.parseInt(this.top.getValue()), 320));
            tag.m_128405_("z", pos1.m_123343_());
            stack.m_41784_().m_128365_("pos1", (Tag)tag);
            tag = new CompoundTag();
            tag.m_128405_("x", pos2.m_123341_());
            tag.m_128405_("y", Math.max(Integer.parseInt(this.down.getValue()), -64));
            tag.m_128405_("z", pos2.m_123343_());
            stack.m_41784_().m_128365_("pos2", (Tag)tag);
            PacketHandler.sendToServer(new AreaCardItemPacket(Minecraft.m_91087_().f_91074_.m_20148_(), stack));
        }
    }

    public void changeFilter(int index) {
        ItemStack stack = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        if (stack.m_41720_() instanceof AreaCardItem) {
            CompoundTag tag = new CompoundTag();
            CompoundTag currentTag = stack.m_41784_().m_128469_("Filters");
            for (int i = 0; i < 9; ++i) {
                if (!currentTag.m_128441_(String.valueOf(i)) || i == index || !currentTag.m_128471_(String.valueOf(i))) continue;
                tag.m_128379_(String.valueOf(i), true);
            }
            if (!currentTag.m_128471_(String.valueOf(index))) {
                tag.m_128379_(String.valueOf(index), true);
            }
            stack.m_41784_().m_128365_("Filters", (Tag)tag);
            PacketHandler.sendToServer(new AreaCardItemPacket(Minecraft.m_91087_().f_91074_.m_20148_(), stack));
        }
    }

    protected void m_181908_() {
        ItemStack stack = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        this.refreshDarkmode();
        super.m_181908_();
        for (ModEditBox editBox : this.positionInputs) {
            if (stack.m_41784_().m_128451_("Selection") != 0) continue;
            editBox.tick();
        }
    }

    public boolean isInputValid(String string) {
        if (string.isEmpty()) {
            return true;
        }
        if (string.length() == 1) {
            return string.matches("[0-9-]");
        }
        return string.split("")[string.split("").length - 1].matches("^-?(\\d+$)");
    }

    public boolean getDarkModeConfigValue() {
        return (Boolean)ClientConfig.enableQuarryDarkmode.get();
    }

    public void setDarkModeConfigValue(boolean state) {
        ClientConfig.enableQuarryDarkmode.set((Object)state);
    }

    public void refreshDarkmode() {
        this.refreshWidgets();
    }

    public void refreshWidgets() {
        this.m_169413_();
        this.addElements();
    }

    @Override
    public int getSizeX() {
        return 197;
    }

    @Override
    public int getSizeY() {
        return 149;
    }

    @Override
    public ResourceLocation getTexture() {
        if (!this.getDarkModeConfigValue()) {
            this.refreshDarkmode();
        }
        String texture = "textures/gui/area_card_gui.png";
        if (this.getDarkModeConfigValue()) {
            texture = "textures/gui/area_card_gui_dark.png";
        }
        return new ResourceLocation("quarry", texture);
    }

    public void drawCenteredText(String text, PoseStack stack, int x, int y) {
        Minecraft.m_91087_().f_91062_.m_92883_(stack, text, (float)x - (float)Minecraft.m_91087_().f_91062_.m_92895_(text) / 2.0f, (float)y, 0x141414);
    }

    public void drawCenteredTextColored(String text, PoseStack stack, int x, int y, int color) {
        Minecraft.m_91087_().f_91062_.m_92883_(stack, text, (float)x - (float)Minecraft.m_91087_().f_91062_.m_92895_(text) / 2.0f, (float)y, color);
    }

    public void drawText(String text, PoseStack stack, int x, int y) {
        Minecraft.m_91087_().f_91062_.m_92883_(stack, text, (float)x, (float)y, 0x141414);
    }
}

